---------------------------------------------------------------------------------------------
-- Creates a patrol armys for steppe robbers
function CreateArmyPatrol()
	leftpatrol = UnlimitedArmy:New({
				Player = 2,
				Area = 3200,
				AutoDestroyIfEmpty = true,
				TransitAttackMove = true,
				Formation = UnlimitedArmy.Formations.Chaotic,
				LeaderFormation = FormationFunktion,
				AIActive = true,
				AutoRotateRange = 100000,
				})
	middlepatrol = UnlimitedArmy:New({
				Player = 2,
				Area = 3200,
				AutoDestroyIfEmpty = true,
				TransitAttackMove = true,
				Formation = UnlimitedArmy.Formations.Chaotic,
				LeaderFormation = FormationFunktion,
				AIActive = true,
				AutoRotateRange = 100000,
				})
	rightpatrol = UnlimitedArmy:New({
				Player = 2,
				Area = 3200,
				AutoDestroyIfEmpty = true,
				TransitAttackMove = true,
				Formation = UnlimitedArmy.Formations.Chaotic,
				LeaderFormation = FormationFunktion,
				AIActive = true,
				AutoRotateRange = 100000,
				})
	local spawntable = {}
	spawntable[1] = GetPosition("P2_SpawnPoint_1")
	spawntable[1].Generator = "P2_RobberyTower_1"
	spawntable[2] = GetPosition("P2_SpawnPoint_5")
	spawntable[2].Generator = "P2_RobberyTower_5"
	spawntable[3] = GetPosition("P2_RandomSpawn_3")
	spawntable[4] = GetPosition("P2_RandomSpawn_2")
	leftpatrolSpawner = UnlimitedArmySpawnGenerator:New(leftpatrol,{
		Position = spawntable,
		ArmySize = 8,
		SpawnCounter = 300,
		SpawnLeaders = 8,
		LeaderDesc = {
			{LeaderType = Entities.PU_LeaderCavalry2, SoldierNum = 3, SpawnNum = 3, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderHeavyCavalry1, SoldierNum = 3, SpawnNum = 3, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderSword2, SoldierNum = 4, SpawnNum = 2, Looped = true, Experience = 3},
		},
		RandomizeSpawnPoint = false
	})
	local spawntable = {}
	spawntable[1] = GetPosition("P2_SpawnPoint_2")
	spawntable[1].Generator = "P2_RobberyTower_2"
	spawntable[2] = GetPosition("P2_RandomSpawn_4")
	spawntable[3] = GetPosition("P2_RandomSpawn_2")
	middlepatrolSpawner = UnlimitedArmySpawnGenerator:New(middlepatrol,{
		Position = spawntable,
		ArmySize = 9,
		SpawnCounter = 300,
		SpawnLeaders = 9,
		LeaderDesc = {
			{LeaderType = Entities.PU_LeaderBow3, SoldierNum = 8, SpawnNum = 3, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderPoleArm2, SoldierNum = 4, SpawnNum = 2, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderHeavyCavalry1, SoldierNum = 3, SpawnNum = 2, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderSword2, SoldierNum = 4, SpawnNum = 3, Looped = true, Experience = 3}
		},
		RandomizeSpawnPoint = false
	})
	local spawntable = {}
	spawntable[1] = GetPosition("P2_SpawnPoint_4")
	spawntable[1].Generator = "P2_RobberyTower_4"
	spawntable[2] = GetPosition("P2_SpawnPoint_3")
	spawntable[2].Generator = "P2_RobberyTower_3"
	spawntable[3] = GetPosition("P2_RandomSpawn_5")
	spawntable[4] = GetPosition("P2_RandomSpawn_2")
	spawntable[4] = GetPosition("P2_RandomSpawn_1")
	rightpatrolSpawner = UnlimitedArmySpawnGenerator:New(rightpatrol,{
		Position = spawntable,
		ArmySize = 8,
		SpawnCounter = 300,
		SpawnLeaders = 8,
		LeaderDesc = {
			{LeaderType = Entities.PU_LeaderRifle1, SoldierNum = 4, SpawnNum = 5, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderPoleArm2, SoldierNum = 4, SpawnNum = 2, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderSword2, SoldierNum = 4, SpawnNum = 4, Looped = true, Experience = 3}
		},
		RandomizeSpawnPoint = false
	})
	StartSimpleJob("ControllSpawners")
	
	leftpatrol:AddCommandMove(GetPosition("leftpatrol3"),true)
	leftpatrol:AddCommandWaitForIdle(true)
	leftpatrol:AddCommandMove(GetPosition("leftpatrol2"),true)
	leftpatrol:AddCommandWaitForIdle(true)
	leftpatrol:AddCommandMove(GetPosition("leftpatrol1"),true)
	leftpatrol:AddCommandWaitForIdle(true)
	leftpatrol:AddCommandMove(GetPosition("Caravan_WP1"),true)
	leftpatrol:AddCommandWaitForIdle(true)
	leftpatrol:AddCommandMove(GetPosition("Caravan_WP2"),true)
	leftpatrol:AddCommandWaitForIdle(true)
	leftpatrol:AddCommandMove(GetPosition("Caravan_WP1"),true)
	leftpatrol:AddCommandWaitForIdle(true)
	leftpatrol:AddCommandMove(GetPosition("leftpatrol1"),true)
	leftpatrol:AddCommandWaitForIdle(true)
	leftpatrol:AddCommandMove(GetPosition("leftpatrol2"),true)
	leftpatrol:AddCommandWaitForIdle(true)
	
	middlepatrol:AddCommandMove(GetPosition("middlePatrol1"),true)
	middlepatrol:AddCommandWaitForIdle(true)
	middlepatrol:AddCommandMove(GetPosition("middlePatrol2"),true)
	middlepatrol:AddCommandWaitForIdle(true)
	middlepatrol:AddCommandMove(GetPosition("middlePatrol1"),true)
	middlepatrol:AddCommandWaitForIdle(true)
	middlepatrol:AddCommandMove(GetPosition("Caravan_WP1"),true)
	middlepatrol:AddCommandWaitForIdle(true)
	middlepatrol:AddCommandMove(GetPosition("Caravan_WP2"),true)
	middlepatrol:AddCommandWaitForIdle(true)
	middlepatrol:AddCommandMove(GetPosition("Caravan_WP1"),true)
	middlepatrol:AddCommandWaitForIdle(true)
	
	rightpatrol:AddCommandMove(GetPosition("Caravan_WP3"),true)
	rightpatrol:AddCommandWaitForIdle(true)
	rightpatrol:AddCommandMove(GetPosition("Caravan_WP2"),true)
	rightpatrol:AddCommandWaitForIdle(true)
	rightpatrol:AddCommandMove(GetPosition("rightPatrol1"),true)
	rightpatrol:AddCommandWaitForIdle(true)
	rightpatrol:AddCommandMove(GetPosition("Caravan_WP5"),true)
	rightpatrol:AddCommandWaitForIdle(true)
	rightpatrol:AddCommandMove(GetPosition("rightPatrol1"),true)
	rightpatrol:AddCommandWaitForIdle(true)
	rightpatrol:AddCommandMove(GetPosition("Caravan_WP2"),true)
	rightpatrol:AddCommandWaitForIdle(true)
	
	DZUA = UnlimitedArmy:New({
				Player = 2,
				Area = 1800,
				AutoDestroyIfEmpty = true,
				TransitAttackMove = true,
				Formation = UnlimitedArmy.Formations.Chaotic,
				LeaderFormation = FormationFunktion,
				AIActive = true
				})
	MineUA = UnlimitedArmy:New({
				Player = 2,
				Area = 2500,
				AutoDestroyIfEmpty = true,
				TransitAttackMove = true,
				Formation = UnlimitedArmy.Formations.Chaotic,
				LeaderFormation = FormationFunktion,
				AIActive = true
				})
	
	DZUA:CreateLeaderForArmy(Entities.CU_BanditLeaderSword1, 8, GetPosition("BanditDZ3"), 3)
	DZUA:CreateLeaderForArmy(Entities.CU_BanditLeaderSword1, 8, GetPosition("BanditDZ3"), 3)
	DZUA:CreateLeaderForArmy(Entities.CU_BanditLeaderSword1, 8, GetPosition("BanditDZ3"), 3)
	DZUA:CreateLeaderForArmy(Entities.CU_BanditLeaderBow1, 4, GetPosition("BanditDZ3"), 3)
	DZUA:CreateLeaderForArmy(Entities.CU_BanditLeaderBow1, 4, GetPosition("BanditDZ3"), 3)
	DZUA:CreateLeaderForArmy(Entities.CU_BanditLeaderBow1, 4, GetPosition("BanditDZ3"), 3)
	
	MineUA:CreateLeaderForArmy(Entities.PU_LeaderSword3, 4, GetPosition("BanditDZ3"), 3)
	MineUA:CreateLeaderForArmy(Entities.PU_LeaderSword3, 4, GetPosition("BanditDZ3"), 3)
	MineUA:CreateLeaderForArmy(Entities.PU_LeaderSword3, 4, GetPosition("BanditDZ3"), 3)
	MineUA:CreateLeaderForArmy(Entities.CU_BanditLeaderBow1, 4, GetPosition("BanditDZ3"), 3)
	MineUA:CreateLeaderForArmy(Entities.CU_BanditLeaderBow1, 4, GetPosition("BanditDZ3"), 3)
	MineUA:CreateLeaderForArmy(Entities.CU_BanditLeaderBow1, 4, GetPosition("BanditDZ3"), 3)
	MineUA:CreateLeaderForArmy(Entities.CU_BanditLeaderBow1, 4, GetPosition("BanditDZ3"), 3)
	
	DZUA:AddCommandMove(GetPosition("BanditDZ3"),true)
	DZUA:AddCommandWaitForIdle(true)
	DZUA:AddCommandMove(GetPosition("BanditDZ2"),true)
	DZUA:AddCommandWaitForIdle(true)
	DZUA:AddCommandMove(GetPosition("BanditDZ1"),true)
	DZUA:AddCommandWaitForIdle(true)
	DZUA:AddCommandMove(GetPosition("BanditDZ2"),true)
	DZUA:AddCommandWaitForIdle(true)
	
	
	MineUA:AddCommandMove(GetPosition("BanditMine4"),true)
	MineUA:AddCommandWaitForIdle(true)
	MineUA:AddCommandMove(GetPosition("BanditMine2"),true)
	MineUA:AddCommandWaitForIdle(true)
	MineUA:AddCommandMove(GetPosition("BanditMine1"),true)
	MineUA:AddCommandWaitForIdle(true)
	MineUA:AddCommandMove(GetPosition("BanditMine2"),true)
	MineUA:AddCommandWaitForIdle(true)
	MineUA:AddCommandMove(GetPosition("BanditMine3"),true)
	MineUA:AddCommandWaitForIdle(true)
	MineUA:AddCommandMove(GetPosition("BanditMine2"),true)
	MineUA:AddCommandWaitForIdle(true)
	
	AttackerTimer = 600
	
	CreateAttackerArmy()
	
end

function ControllSpawners()
	if IsDead("P2_RobberyTower_2") then
		if middlepatrolSpawner.ArmySize == 9 then
			middlepatrolSpawner.ArmySize = 5
			middlepatrolSpawner.SpawnLeaders = 5
			middlepatrolSpawner.RandomizeSpawnPoint = true
		end
	end
	if IsDead("P2_RobberyTower_4") and IsDead("P2_RobberyTower_3") then
		if rightpatrolSpawner.ArmySize == 8 then
			rightpatrolSpawner.ArmySize = 5
			rightpatrolSpawner.SpawnLeaders = 5
			rightpatrolSpawner.RandomizeSpawnPoint = true
		end
	end
	if IsDead("P2_RobberyTower_5") and IsDead("P2_RobberyTower_1") then
		if leftpatrolSpawner.ArmySize == 8 then
			leftpatrolSpawner.ArmySize = 5
			leftpatrolSpawner.SpawnLeaders = 5
			leftpatrolSpawner.RandomizeSpawnPoint = true
		end
	end
	
	if IsDead("P2_RobberyTower_5") and IsDead("P2_RobberyTower_1") and IsDead("P2_RobberyTower_3")
	and IsDead("P2_RobberyTower_2") and IsDead("P2_RobberyTower_4") then
		return true
	end
	return false
end

function CreateAttackerArmy()
	AttackerUA=UnlimitedArmy:New({
				Player = 2,
				Area = 3800,
				TransitAttackMove = true,
				Formation = UnlimitedArmy.Formations.Chaotic,
				LeaderFormation = FormationFunktion,
				AIActive = true
				})
	AttackerUA.groupup = false
	AttackerUA.size = 5
	AttackerUA.SpawnCounter = 600
	AttackerUA.SpawnTable = {Entities.PU_LeaderHeavyCavalry1,
							Entities.PU_LeaderCavalry1}
	AttackerUA:AddCommandLuaFunc(AttackIt,true)
end

function AttackIt(self)
	if self.SpawnCounter <= 0 then
		local enttype1
		local enttype2
		local Spawnpos = GetPosition("P2_RandomSpawn_"..math.random(1,5))
			if self.size <= 6 then
				enttype1 = Entities.PU_LeaderCavalry1
				enttype2 = Entities.PU_LeaderHeavyCavalry1
			else
				enttype1 = Entities.PU_LeaderCavalry2
				enttype2 = Entities.PU_LeaderHeavyCavalry2
			end
		for i = 1,self.size,1 do
			if math.mod(i,3) ~= 0 then
				self:CreateLeaderForArmy(enttype1, 3,Spawnpos,3)
			else
				self:CreateLeaderForArmy(enttype2, 3,Spawnpos,3)
			end
		end
		self.SpawnCounter = AttackerTimer
		if self.size <= 20 then
			self.size = self.size + 1
		end
	else
		self.SpawnCounter = self.SpawnCounter - 1
	end
	if self:IsIdle() then
		self.groupup = false
		return true, UnlimitedArmy.CreateCommandAttackNearestTarget(nil)
	else
		if not self.groupup then
			if Counter.Tick2("AttackerUATicker",10) then
				local distance = 12100000000
				local tempdis
				local temppos 
				for troop in self:Iterator(false) do
					temppos = GetPosition(troop)
					tempdis = GetSimpleDistanceSquared(temppos,self.Target)
					if tempdis <= distance then
						distance = tempdis
						self.UAPos = temppos
					end
				end
				self.groupup = true
				return true, UnlimitedArmy.CreateCommandDefend(self.UAPos,3800)
			end
		else
			return true
		end
	end
	return false
end

function GetSimpleDistanceSquared(_pos1,_pos2)
	return (_pos1.X - _pos2.X)^2 + (_pos1.Y - _pos2.Y)^2
end